<?php
if (!defined('ABSPATH')) {
    exit;
}

if (has_post_thumbnail()) {
    $thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), 'givelove-featured-image-small');
} else {
    $thumbnail_url = givelove_get_placeholder_image();
}

if(!isset($post->layout1) && !isset($post->layout2)){
    $post->layout1 = 4;
    $post->layout2 = 8;
}
?>
<article <?php post_class('osf-event-article'); ?>>
    <div class="post-inner row">
        <div class="post-thumbnail col-lg-<?php echo esc_attr($post->layout1); ?> col-md-12">
            <div class="entry-meta">
                <?php if (!empty(osf_get_metabox(get_the_ID(), 'osf_event_date'))): ?>
                    <div class="entry-date"><?php echo sprintf('<time datetime="%1$s">%2$s</time>', date(DATE_W3C, osf_get_metabox(get_the_ID(), 'osf_event_date')), date('<b>d</b> M', osf_get_metabox(get_the_ID(), 'osf_event_date'))); ?></div>
                <?php endif; ?>
                <div class="event-info">
                    <div>
                        <?php if (!empty(osf_get_metabox(get_the_ID(), 'osf_event_date'))): ?>
                            <i class="fa fa-clock-o c-primary"></i>
                            <?php echo sprintf('<time datetime="%1$s">%2$s</time>',
                                date(DATE_W3C, osf_get_metabox(get_the_ID(), 'osf_event_date')),
                                date('M d@ h:ia', osf_get_metabox(get_the_ID(), 'osf_event_date'))
                            );
                            ?>
                        <?php endif; ?>
                        <?php if (!empty(osf_get_metabox(get_the_ID(), 'osf_event_date_end')) && !empty(osf_get_metabox(get_the_ID(), 'osf_event_date'))): ?>
                            <?php echo sprintf('<time datetime="%1$s">- %2$s</time>',
                                date(DATE_W3C, osf_get_metabox(get_the_ID(), 'osf_event_date_end')),
                                date('M d@ h:ia', osf_get_metabox(get_the_ID(), 'osf_event_date_end'))
                            );
                            ?>
                        <?php endif; ?>
                    </div>
                    <?php if (!empty(osf_get_metabox(get_the_ID(), 'osf_event_venue_add'))): ?>
                        <div class="event-add">
                            <i class="fa fa-map-marker c-primary"></i><?php echo osf_get_metabox(get_the_ID(), 'osf_event_venue_add'); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div><!-- .post-thumbnail -->
        <div class="entry-content col-lg-<?php echo esc_attr($post->layout2); ?> col-md-12">
            <div class="event-content-wrap">
                <header class="entry-header">
                    <?php the_title('<h3 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>'); ?>
                </header><!-- .entry-header -->
                <p class="description"><?php echo givelove_get_excerpt(19); ?></p>
            </div>
        </div>
    </div>
</article>
<!-- #post-## -->

