<?php

class OSF_Import {
    private $config, $path_rev, $homepage, $blogpage, $header, $footer, $contactForm, $mailchimp, $templates, $settings;

    public function __construct() {
        if (is_admin()) {
            $this->path_rev = trailingslashit(wp_upload_dir()['basedir']) . 'opal_rev_sliders_import/';
            add_action('after_setup_theme', array($this, 'init'));
        }
    }

    public function init() {
        $this->init_hooks();
        add_filter('pt-ocdi/disable_pt_branding', '__return_true');
    }

    public function init_hooks() {
        add_action('osf_before_import_customizer', array($this, 'reset_theme_mods'));
        if (get_option('otf-oneclick-first-import', 'yes') === 'yes') {
            add_filter('pt-ocdi/import_files', array($this, 'import_file_base'));
            add_action('pt-ocdi/after_import', array($this, 'after_import_setup'));
            add_action('pt-ocdi/after_import', array($this, 'after_import_setup_base'), 20);
        } else {
            add_filter('pt-ocdi/import_files', array($this, 'import_files'));
            add_action('pt-ocdi/after_import', array($this, 'after_import_setup'));
            add_filter('pt-ocdi/enable_grid_layout_import_popup_confirmation', '__return_false');
            add_filter('otf-ocdi/reload_page', '__return_false');
        }
    }

    public function import_file_base() {
        $this->init_data();
        $imports   = array();
        $import    = array(
            'import_file_name'       => 'Basic',
            'local_import_file'      => trailingslashit(GIVELOVE_CORE_PLUGIN_DIR) . 'dummy-data/content.xml',
            'import_notice'          => 'Basic import includes default version from our demo and a few products, blog posts and portfolio projects. It is a required minimum to see how our theme built and to be able to import additional versions or pages.',
            'slug'                   => '01',
            'import_widget_file_url' => 'http://source.wpopal.com/givelove/dummy_data/givelove/01/widgets.json'
        );
        $imports[] = $import;

        return $imports;
    }

    public function import_files() {
        $this->init_data();
        $imports = array();
        foreach ($this->config as $key => $niche) {
            $import = array(
                'import_file_name'         => $niche['name'],
                'import_preview_image_url' => $niche['screenshot'],
                'slug'                     => $key,
            );
            if (isset($niche['xml'])) {
                $import['import_file_url'] = $niche['xml'];
            }
            if (isset($niche['widgets'])) {
                $import['import_widget_file_url'] = $niche['widgets'];
            }

            $imports[] = $import;
        }

        return $imports;
    }

    private function init_data() {
        $this->config   = json_decode(file_get_contents(trailingslashit(GIVELOVE_CORE_PLUGIN_DIR) . 'dummy-data/config.json'), true);
        $this->homepage = get_page_by_title('Home 1');
        $this->blogpage = get_page_by_title('Blog List');
    }

    public function after_import_setup_base($selected_import) {
        update_option('show_on_front', 'page');
        update_option('page_on_front', (($this->homepage instanceof WP_Post) ? $this->homepage->ID : 0));
        update_option('page_for_posts', (($this->blogpage instanceof WP_Post) ? $this->blogpage->ID : 0));
        update_option('otf-oneclick-first-import', 'no');

        // Parallax
        $options                                = get_option('granular_editor_settings', array());
        $options['granular_editor_parallax_on'] = 'yes';
        update_option('granular_editor_settings', $options);

        // Give
        if ($this->settings['give']) {
            unset($this->settings['give']['success_page']);
            unset($this->settings['give']['failure_page']);
            unset($this->settings['give']['history_page']);
            unset($this->settings['give']['new-offline-donation_recipient']);
            unset($this->settings['give']['new-donor-register_recipient']);
            update_option('give_settings', $this->settings['give']);
        }
        $this->setup_give_form();
    }

    private function setup_give_form() {
        $query = new WP_Query(array(
            'post_type'      => 'give_forms',
            'posts_per_page' => -1
        ));
        $video = 'https://www.youtube.com/watch?v=xLfxeosUg0E';
        $content
               = <<<HTML
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.

Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.

<img class="alignright size-full wp-image-394" src="http://source.wpopal.com/givelove/wp-content/uploads/2018/12/donation-detail.jpg" alt="" width="400" height="530" />

<strong>Challenge</strong>

Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam

<strong>Our Work</strong>

Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.

<strong>Summary</strong>

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas.

&nbsp;
<blockquote>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim eniamuis aute irure dolor in reprehenderit</blockquote>
&nbsp;

Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.

Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.
HTML;

        while ($query->have_posts()): $query->the_post();
            $postid = get_the_ID();
            give_update_meta($postid, '_give_goal_format', 'amount');
            delete_post_meta($postid, '_give_goal_color');
            give_update_meta($postid, '_give_form_content', $content);
            give_update_meta($postid, '_give_payment_display', 'onpage');
            give_update_meta($postid, '_give_display_style', 'button');
            give_update_meta($postid, '_give_goal_option', 'enabled');
            give_update_meta($postid, '_give_set_goal', '1000');
            give_update_meta($postid, '_give_display_content', 'enabled');
            give_update_meta($postid, '_give_content_placement', 'give_pre_form');
            update_post_meta($postid, 'osf_give_video', $video);
            set_post_thumbnail($postid, 1032);
        endwhile;
    }


    public function after_import_setup($selected_import) {
        if (isset($this->config[$selected_import['slug']])) {

            $setup = $this->config[$selected_import['slug']];

            // REVSLIDER
            if ($sliders = $setup['rev_sliders']) {
                if (class_exists('RevSliderAdmin')) {
                    if (!file_exists($this->path_rev)) {
                        wp_mkdir_p($this->path_rev);
                    }
                    foreach ($sliders as $slider) {
                        $this->add_revslider($slider);
                    }
                }
            }

            $settings        = $this->get_remote_json($setup['settings'], true);
            $this->settings  = $settings;
            $this->templates = $settings['templates'];

            // Setup Customizer
            $this->reset_theme_mods();
            $thememods = $settings['thememods'];
            foreach ($thememods as $mod => $value) {
                set_theme_mod($mod, $value);
            }

            // Setup Elementor
            if (osf_is_elementor_activated()) {
                foreach ($settings['elementor'] as $key => $value) {
                    update_option($key, $value);
                }
                $global = new Elementor\Core\Files\CSS\Global_CSS('global.css');
                $global->update_file();
                // Homepage
                $this->setup_homepage($settings['homepage'], $settings['homepage-custom']);
                $this->update_url_elementor();
                \Elementor\Plugin::$instance->files_manager->clear_cache();
            }

            // Custom Css
            if ($settings['custom_css']) {
                wp_update_custom_css_post($settings['custom_css']);
            }

            // Mailchimp
            $mailchimp = get_page_by_title('Opal MailChimp', OBJECT, 'mc4wp-form');
            if ($mailchimp) {
                update_option('mc4wp_default_form_id', $mailchimp->ID);
            }

        }
        set_theme_mod('osf_dev_mode', false);
    }

    private function setup_homepage($data, $custom) {
        $data = $this->update_image_elementor($data);
        update_post_meta($this->homepage->ID, '_elementor_data', wp_slash(wp_json_encode($data)));
        $bc = new Elementor\Core\Files\CSS\Post($this->homepage->ID);
        $bc->update();

        foreach ($custom as $key => $value) {
            update_post_meta($this->homepage->ID, $key, $value);
        }
    }

    private function add_revslider($slider) {
        $dest_rev = $this->path_rev . basename($slider);
        if (!file_exists($dest_rev)) {
            file_put_contents($dest_rev, wp_remote_fopen($slider));
            $_FILES['import_file']['error']    = UPLOAD_ERR_OK;
            $_FILES['import_file']['tmp_name'] = $dest_rev;

            $revslider = new RevSlider();
            $revslider->importSliderFromPost(true, 'none');
        }
    }

    /**
     * @param $link
     *
     * @return object|boolean
     */
    private function get_remote_json($link, $assoc = false) {
        $content = wp_remote_get($link);
        if ($content instanceof WP_Error) {
            return false;
        }

        return json_decode($content['body'], $assoc);
    }

    public function reset_theme_mods() {
        $mods = json_decode(file_get_contents(trailingslashit(GIVELOVE_CORE_PLUGIN_DIR) . 'reset-theme-mods.json'));
        foreach ($mods as $mod) {
            remove_theme_mod($mod);
        }
    }

    private function update_image_elementor($datas) {
        if (count($datas) <= 0) {
            return $datas;
        }
        foreach ($datas as $key => $data) {
            if (!empty($data['settings']['background_image'])) {
                $data['settings']['backgbackground_image']['id'] = $this->get_image_id($data['settings']['backgbackground_image']['url']);
            }

            if (!empty($data['settings']['background_hover_image'])) {
                $data['settings']['background_hover_image']['id'] = $this->get_image_id($data['settings']['background_hover_image']['url']);
            }

            // Call To action
            if (!empty($data['settings']['bg_image'])) {
                $data['settings']['bg_image']['id'] = $this->get_image_id($data['settings']['bg_image']['url']);
            }

            // Image
            if (!empty($data['widgetType']) && $data['widgetType'] === 'image') {
                $data['settings']['image']['id'] = $this->get_image_id($data['settings']['image']['url']);
            }

            // Image Layers
            if (!empty($data['widgetType']) && $data['widgetType'] === 'opal-images-layers') {
                if (count($data['settings']['img_layers_images_repeater']) > 0) {
                    foreach ($data['settings']['img_layers_images_repeater'] as $k => $repeater) {
                        if (isset($repeater['img_layers_image'])) {
                            $data['settings']['img_layers_images_repeater'][$k]['img_layers_image']['id'] = $this->get_image_id($repeater['img_layers_image']['url']);
                        }
                    }
                }
            }

            // 360
            if (!empty($data['widgetType']) && $data['widgetType'] === 'rotate-image') {
                if (count($data['settings']['carousel']) > 0) {
                    foreach ($data['settings']['carousel'] as $k => $carousel) {
                        $data['settings']['carousel'][$k]['id'] = $this->get_image_id($carousel['url']);
                    }
                }

            }

            // Tab Template ID
            if (!empty($data['widgetType']) && $data['widgetType'] === 'opal-tabs') {
                if (count($data['settings']['tabs']) > 0) {
                    foreach ($data['settings']['tabs'] as $k => $tab) {
                        if (isset($tab['tab_template']) && $tab['tab_template']) {
                            $title                                        = $this->templates[$tab['tab_template']];
                            $template                                     = get_page_by_title($title, OBJECT, 'elementor_library');
                            $data['settings']['tabs'][$k]['tab_template'] = $template->ID;
                        }
                    }
                }
            }

            // Contact Form
//            if ( ! empty( $data['widgetType'] ) && $data['widgetType'] === 'opal-contactform7' ) {
//                $data['settings']['cf_id'] = $this->contactForm->ID;
//            }

            if (!empty($data['widgetType']) && $data['widgetType'] === 'image-box') {
                $data['settings']['image']['id'] = $this->get_image_id($data['settings']['image']['url']);
            }

            if (!empty($data['elements'])) {
                $data['elements'] = $this->update_image_elementor($data['elements']);
            }


            $datas[$key] = $data;
        }

        return $datas;
    }

    private function get_image_id($image_url) {
        global $wpdb;
        $attachment = $wpdb->get_col($wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE guid='%s';", $image_url));

        return $attachment[0];
    }

    private function update_url_elementor() {
        $from          = 'http://source.wpopal.com/givelove';
        $to            = site_url();
        $is_valid_urls = (filter_var($from, FILTER_VALIDATE_URL) && filter_var($to, FILTER_VALIDATE_URL));
        if (!$is_valid_urls) {
            return false;
        }

        if ($from === $to) {
            return false;
        }


        global $wpdb;

        // @codingStandardsIgnoreStart cannot use `$wpdb->prepare` because it remove's the backslashes
        $rows_affected = $wpdb->query(
            "UPDATE {$wpdb->postmeta} " .
            "SET `meta_value` = REPLACE(`meta_value`, '" . str_replace('/', '\\\/', $from) . "', '" . str_replace('/', '\\\/', $to) . "') " .
            "WHERE `meta_key` = '_elementor_data' AND `meta_value` LIKE '[%' ;"); // meta_value LIKE '[%' are json formatted
        // @codingStandardsIgnoreEnd

    }
}

return new OSF_Import();
